"use client"

import {Card, CardContent, CardDescription, CardHeader, CardTitle} from "@/components/ui/card";
import {Label} from "@/components/ui/label";
import {Input} from "@/components/ui/input";
import {Button} from "@/components/ui/button";
import Link from "next/link";
import {useState} from "react";
import { verifyOTP } from "@/lib/api";
import {useRouter} from "next/navigation";

export default function OTPPage(){

    const router = useRouter();
    const [otp, setOtp] = useState('');
    const [error, setError] = useState('');
    const email = sessionStorage.getItem('email');

    const handleOTP = async (e) => {
        e.preventDefault();

        try{
            const res = await verifyOTP({
                otp: otp,
                email: sessionStorage.getItem('email')
            });
            if(res.status === "success"){
                console.log(res);
                alert("Successfully! " + res.message);
                sessionStorage.removeItem('email');
                router.push('/reset-password');
            }
        }
        catch(err){
            setError(err);
            console.log(err);
            alert(err);
        }
    }

    return(
        <div className="flex min-h-screen flex-col items-center p-24">
            <Card className="w-[400px]">
                <CardHeader>
                    <CardTitle>Enter OTP</CardTitle>
                    <CardDescription>You will get an email with 6 digit OTP on {email} </CardDescription>
                    {error && <p className="text-red-500">{error}</p>}
                </CardHeader>
                <CardContent>
                    <form onSubmit={handleOTP}>
                        <div className="grid w-full items-center gap-4 mb-3">
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="otp">Enter 6 Digit OTP</Label>
                                <Input name="otp" id="otp" type="number" length="6" value={otp} onChange={(e) => setOtp(e.target.value)} placeholder="6 Digit OTP" />
                            </div>
                            <div className="flex justify-between w-full">
                                <Button type="submit">Submit OTP</Button>
                                <Link href="/login"><Button variant="outline">Login</Button></Link>
                            </div>
                        </div>
                    </form>
                </CardContent>
            </Card>
        </div>
    )
}