"use client";

import { useState } from "react";
import {Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle} from "@/components/ui/card";
import {Label} from "@/components/ui/label";
import {Input} from "@/components/ui/input";
import {Button} from "@/components/ui/button";
import Link from "next/link";
import useAuth from "@/lib/useAuth";
import {useRouter} from "next/navigation";
import {registerUser} from "@/lib/api";

export default function RegisterPage(){
    const { register } = useAuth();
    const [formData, setFormData] = useState({ name: '', email: '', password: '', address: '', phone: '' });
    const [error, setError] = useState('');
    const router = useRouter();

    const handleRegister = async (e) => {
        e.preventDefault();
        setError('');
        try {
            const res = await registerUser(formData.name, formData.email, formData.password, formData.address, formData.phone);
            // const resisterData = await register(formData.name, formData.email, formData.password);
            if(res.status === "success") {
                alert("User registered successfully");
                router.push('/login');
            }
        } catch (err) {
            if(err.response && err.response.data) {
                const errors = err.response.data.errors;
                if(errors) {
                    const errorMessages = Object.values(errors).flat().join(' ');
                    setError(errorMessages);
                }else{
                    setError(err.response.data.message);
                }
            } else if(err.request){
                setError("Server error. Please try again later");
            } else {
                setError(err.message);
            }
        }
    }

    return(
        <div className="flex min-h-screen flex-col items-center p-24">
            <Card className="w-[400px]">
                <CardHeader>
                    <CardTitle>Register User</CardTitle>
                    <CardDescription>Please signup with your credentials</CardDescription>
                    {error && (
                        <div className="text-red-500">
                            {error.split('. ').map((errMsg, index) => (
                                <p key={index}>{errMsg}</p>
                            ))}
                        </div>
                    )}
                </CardHeader>
                <CardContent>
                    <form onSubmit={handleRegister}>
                        <div className="grid w-full items-center gap-4 mb-3">
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="name">Full Name</Label>
                                <Input name="name" id="name" type="text" value={formData.name} onChange={(e) => setFormData({...formData, name: e.target.value})} placeholder="Full Name" />
                            </div>
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="email">Email Address</Label>
                                <Input name="email" id="email" type="email" value={formData.email} onChange={(e) => setFormData({...formData, email: e.target.value})} placeholder="Email" />
                            </div>
                            <div className="flex flex-col space-y-1.0">
                                <Label className="mb-2 px-3" htmlFor="password">Password</Label>
                                <Input name="password" id="password" type="password" value={formData.password} onChange={(e) => setFormData({...formData, password: e.target.value})} placeholder="Password" />
                            </div>
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="address">Full Address</Label>
                                <Input name="address" id="address" type="text" value={formData.address} onChange={(e) => setFormData({...formData, address: e.target.value})} placeholder="Address" />
                            </div>
                            <div className="flex flex-col space-y-1.0 mb-1">
                                <Label className="mb-2 px-3" htmlFor="phone">Contact Number</Label>
                                <Input name="phone" id="phone" type="text" value={formData.phone} onChange={(e) => setFormData({...formData, phone: e.target.value})} placeholder="Phone" />
                            </div>
                        </div>
                        <Button type="submit">Signup</Button>
                    </form>
                </CardContent>
                <CardFooter className="flex justify-between">
                    <p className="text-sm">Already have an account? <Link className="underline" href="/login">Sign In</Link></p>
                </CardFooter>
            </Card>
        </div>
    )
}