"use client"

import {Label} from "@/components/ui/label";
import {Input} from "@/components/ui/input";
import {Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle} from "@/components/ui/card";
import {Button} from "@/components/ui/button";
import Link from "next/link";
import {Textarea} from "@/components/ui/textarea";
import {changePassword, updateUserProfile} from "@/lib/api";
import useAuth from "@/lib/useAuth";
import {useEffect, useState} from "react";
import Image from "next/image";
import {useRouter} from "next/navigation";
import {toast} from "sonner";
import {Accordion, AccordionContent, AccordionItem, AccordionTrigger} from "@/components/ui/accordion";

export default function Profile(){

    const router = useRouter();

    const { userProfile } = useAuth();
    const [person, setPerson] = useState(null);
    const [updateUser, setUpdateUser] = useState({
        address: '',
        phone: '',
        image: '',
        file_path: '',
        newImage: null,
    });

    const [updatePassword, setUpdatePassword] = useState({
        currentPassword: '',
        newPassword: '',
        confirmPassword: '',
    });

    useEffect(() => {
        async function getUserProfile() {
            const res = await userProfile();
            setPerson(res);
            setUpdateUser({
                address: res.user.user_profile.address || '',
                phone: res.user.user_profile.phone || '',
                file_path: res.user.user_profile.image || '',
                image: res.user.user_profile.image || '',
            });
            // console.log(res);
        }
        getUserProfile();
    }, [ userProfile ]);

    const handleChange = (e) => {
        const { name, value, files } = e.target;
        setUpdateUser((prev) => ({
            ...prev,
            [name]: files ? files[0] : value,
            newImage: files ? files[0] : null,
        }));
    };

    const handleUpdate = async (e) => {
        e.preventDefault();

        const action = e.nativeEvent.submitter.value;

        if (action === "updatePassword"){
            if(updatePassword.currentPassword === '' || updatePassword.newPassword === '' || updatePassword.confirmPassword === ''){
                toast.error("Please fill in all fields!");
                return;
            }

            if(updatePassword.newPassword !== updatePassword.confirmPassword){
                toast.error("Passwords do not match!");
                return;
            }

            try{
                const res = await changePassword(
                    updatePassword.currentPassword,
                    updatePassword.newPassword,
                );
                toast.success(res.message + " Please login again.");
                setTimeout(() => {
                    router.push('/login');
                }, 2000);
            }
            catch (err) {
                console.error(err);
                toast.error(err.response.data.message);
            }
        }else if(action === "updateProfile"){
            const updateData = new FormData();
            updateData.append('address', updateUser.address);
            updateData.append('phone', updateUser.phone);
            updateData.append('file_path', updateUser.file_path);
            if (updateUser.image) {
                updateData.append('image', updateUser.image);
            }
            try {
                const res = await updateUserProfile(updateData);
                // alert("Successfully! " + res.message);
                toast.success(res.message, {
                    className: 'bg-green-600 text-white',
                    description: 'User - ' + res.user.name,
                });
                if (res.user.role === 'user'){
                    router.push('/user/profile');
                } else {
                    router.push('/admin/profile');
                }
            } catch (err) {
                console.error(err);
            }
        }
    };


    return(
            <Card className="w-full">
                <CardHeader>
                    <CardTitle>User Profile</CardTitle>
                    <CardDescription>Please check your account details</CardDescription>
                </CardHeader>
                <form onSubmit={handleUpdate}>
                    {/*<input type="hidden" name="action" value="" id="action-input" />*/}
                <CardContent>
                    <div className="flex flex-col-2 px-10 gap-6 justify-between">
                        <div className="flex flex-col space-y-1.0">
                            <div className="flex flex-row space-y-1.0 mb-2">
                                <Label className="mb-2 p-3" htmlFor="Name">Name</Label>
                                <Input className="bg-gray-200 text-black ml-6" name="name" id="name" type="text" value={person?.user?.name} disabled />
                            </div>
                            <div className="flex flex-row space-y-1.0 mb-2">
                                <Label className="mb-2 p-3" htmlFor="email">Email</Label>
                                <Input className="bg-gray-200 text-black ml-7" name="email" id="email" type="email" value={person?.user?.email} disabled />
                            </div>
                            <div className="flex flex-row space-y-1.0 mb-2">
                                <Label className="mb-2 p-3" htmlFor="role">Role</Label>
                                <Input className="bg-gray-200 text-black ml-9" name="role" id="role" type="text" value={person?.user?.role} disabled />
                            </div>
                            <div className="flex flex-row space-y-1.0 mb-2">
                                <Label className="mb-2 p-3" htmlFor="status">Status</Label>
                                <Input className="bg-gray-200 text-black ml-5" name="status" id="status" type="text" value={person?.user?.status} disabled />
                            </div>

                            <Card className="mb-2 px-2">
                                <Accordion type="single" collapsible>
                                    <AccordionItem value="item-1">
                                        <AccordionTrigger className="text-sm">Change Password?</AccordionTrigger>
                                        <AccordionContent className="grid grid-cols-2 gap-3">
                                            <div className="mt-2 px-2">
                                                <div className="mb-2">
                                                    <Input type="password" placeholder="Current Password" className="w-full" name="current_password" id="current_password" value={updatePassword.currentPassword} onChange={(e) => setUpdatePassword({...updatePassword, currentPassword: e.target.value})} />
                                                </div>
                                                <div className="mb-2">
                                                    <Input type="password" placeholder="New Password" className="w-full" name="password" id="password" value={updatePassword.newPassword} onChange={(e) => setUpdatePassword({...updatePassword, newPassword: e.target.value})} />
                                                </div>
                                                <div>
                                                    <Input type="password" placeholder="Confirm Password" className="w-full" name="confirm_password" id="confirm_password" value={updatePassword.confirmPassword} onChange={(e) => setUpdatePassword({...updatePassword, confirmPassword: e.target.value})} />
                                                </div>
                                            </div>
                                            <div className="mt-[6.5rem]">
                                                {/*<button name="action" value="updatePassword" type="submit" className="w-4/6 bg-green-600 rounded-md p-3">Update Password</button>*/}
                                                <Button name="action" value="updatePassword" type="submit" className="w-4/6">Update Password</Button>
                                                {/*<Button*/}
                                                {/*    name="updatePassword"*/}
                                                {/*    type="submit"*/}
                                                {/*    className="w-4/6"*/}
                                                {/*    onClick={() => document.getElementById('action-input').value = 'updatePassword'}*/}
                                                {/*>*/}
                                                {/*    Update Password*/}
                                                {/*</Button>*/}
                                            </div>
                                        </AccordionContent>
                                    </AccordionItem>
                                </Accordion>
                                {/*<ChangePassword />*/}
                            </Card>

                        </div>
                        <div className="flex flex-col space-y-1.0">
                            <div className="flex flex-row space-y-1.0 mb-3">
                                <Label className="mb-2 p-3" htmlFor="address">Address</Label>
                                <Textarea name="address" id="address" rows={3} value={updateUser.address} onChange={handleChange} />
                            </div>
                            <div className="flex flex-row space-y-1.0 mb-3">
                                <Label className="mb-2 p-3" htmlFor="phone">Phone</Label>
                                <Input name="phone" id="phone" type="text" value={updateUser.phone} onChange={handleChange} />
                            </div>
                            <div className="flex flex-row space-y-1.0 mb-3">
                                {updateUser.newImage ? (
                                    <Image
                                        src={URL.createObjectURL(updateUser.newImage)}
                                        width={100}
                                        height={100}
                                        alt="profile"
                                        className="rounded-xl shadow mx-4"
                                    />
                                ) :(
                                    <Image
                                        src={`http://localhost:8000/${updateUser.image}`} // Use absolute URL with backend address
                                        width={100}
                                        height={100}
                                        alt="profile"
                                        className="rounded-xl shadow mx-4"
                                    />
                                )}
                                <div className="py-3">
                                    <Label className="mb-2 px-3" htmlFor="image">Upload New Image</Label>
                                    <Input className="bottom-0.5" name="image" id="image" type="file" onChange={handleChange} />
                                </div>
                                <Input name="file_path" id="file_path" type="hidden" value={updateUser.file_path} disabled/>
                            </div>
                        </div>

                    </div>
                </CardContent>
                <CardFooter>
                    <div className="flex flex-row px-10 justify-between w-full">
                        {/*<Link className="bg-green-600 rounded-md p-3 text-sm hover:bg-green-700 hover:text-white transition-colors" href="/user">Goto Home</Link>*/}
                        <Link className="bg-blue-400 rounded-md p-3 text-sm hover:bg-blue-500 hover:text-white transition-colors" href={person?.user?.role === 'admin' ? '/admin' : '/user' }>Goto Home</Link>
                        <Button type="submit" name="action" value="updateProfile">Update Profile</Button>
                        {/*<Button*/}
                        {/*    type="submit"*/}
                        {/*    name="updateProfile"*/}
                        {/*    onClick={() => document.getElementById('action-input').value = 'updateProfile'}*/}
                        {/*>*/}
                        {/*    Update Profile*/}
                        {/*</Button>*/}
                    </div>
                </CardFooter>
            </form>
            </Card>
    )
}