
import { ModeToggle } from "@/components/theme-switcher";
import Link from "next/link";

import { jwtDecode } from "jwt-decode";
import { cookies } from 'next/headers';

import { cn } from "@/lib/utils"
import {
    NavigationMenu,
    NavigationMenuContent,
    NavigationMenuItem,
    NavigationMenuLink,
    NavigationMenuList,
    NavigationMenuTrigger,
    navigationMenuTriggerStyle,
} from "@/components/ui/navigation-menu"

import { Button } from "@/components/ui/button"
import {
    DropdownMenu,
    DropdownMenuContent,
    DropdownMenuItem,
    DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu"
import Logout from "@/app/components/logout";
import {CircleUserRound} from "lucide-react";


export default function Navbar() {
    // const authToken = cookies().get('authToken')?.value;
    // let user = null;
    //
    // if (authToken) {
    //     try{
    //         user = jwtDecode(authToken);
    //         console.log(user);
    //     }
    //     catch(err) {
    //         console.error(err);
    //     }
    // }

    const token = cookies().get('authToken')?.value;
    let user = jwtDecode(token);

    return user['role'] === 'admin' ? (
        <div className="flex justify-between px-3 py-2 border-b sticky shadow">
            <h2 className="text-xl">
                <Link href="/admin">JWT Auth</Link>
            </h2>
            <NavigationMenu>
                <NavigationMenuList>
                    <NavigationMenuItem>
                        <NavigationMenuTrigger>{user['email']}</NavigationMenuTrigger>
                        <NavigationMenuContent>
                            <ul className="grid gap-3 p-6">
                                <li className="text-sm">
                                    <Link href="/admin/profile" className={cn(navigationMenuTriggerStyle())}>
                                        User Profile
                                    </Link>
                                </li>
                                <li className={cn(navigationMenuTriggerStyle())}>
                                    <Logout className="hover:text-foreground hover:" />
                                </li>
                            </ul>
                        </NavigationMenuContent>
                    </NavigationMenuItem>
                </NavigationMenuList>
            </NavigationMenu>
        </div>
    ) : (
        <div className="flex justify-between px-3 py-2 border-b sticky shadow">
            <h2 className="text-xl">
                <Link href="/user">JWT Auth</Link>
            </h2>
                <NavigationMenu>
                    <NavigationMenuList>
                        <NavigationMenuItem>
                            <NavigationMenuTrigger>{user['email']}</NavigationMenuTrigger>
                            <NavigationMenuContent>
                                <ul className="grid gap-3 p-6">
                                    <li className="text-sm">
                                        <Link href="/user/profile" className={cn(navigationMenuTriggerStyle())}>
                                            User Profile
                                        </Link>
                                    </li>
                                    <li className={cn(navigationMenuTriggerStyle())}>
                                        <Logout />
                                    </li>
                                </ul>
                            </NavigationMenuContent>
                        </NavigationMenuItem>
                    </NavigationMenuList>
                </NavigationMenu>
        </div>
    )

    // Also, you can use below return instead of above
    // return user['role'] === 'admin' ? (
    //         <div className="flex justify-between px-3 py-2 border-b sticky shadow">
    //             <h2 className="text-xl">
    //                 <Link href="/admin">JWT Auth</Link>
    //             </h2>
    //             <nav>
    //                 <ul className="flex gap-2">
    //                     <li>
    //                         <DropdownMenu>
    //                             <DropdownMenuTrigger asChild>
    //                                 <Button variant="outline" size="icon">
    //                                     <CircleUserRound className="h-[1.2rem] w-[1.2rem] rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0" />
    //                                     <span className="sr-only">Toggle theme</span>
    //                                 </Button>
    //                             </DropdownMenuTrigger>
    //                             <DropdownMenuContent align="end">
    //                                 <DropdownMenuItem >
    //                                     <Link href="/admin/profile">{user['email']}</Link>
    //                                 </DropdownMenuItem>
    //                                 <DropdownMenuItem>
    //                                     <Logout/>
    //                                 </DropdownMenuItem>
    //                             </DropdownMenuContent>
    //                         </DropdownMenu>
    //                     </li>
    //
    //
    //                     <li><ModeToggle /></li>
    //                 </ul>
    //             </nav>
    //         </div>
    // ) : (
    //         <div className="flex justify-between px-3 py-2 border-b sticky shadow">
    //             <h2 className="text-xl">
    //                 <Link href="/user">JWT Auth</Link>
    //             </h2>
    //             <nav>
    //                 <ul className="flex gap-2">
    //                     <li>
    //                         <DropdownMenu>
    //                             <DropdownMenuTrigger asChild>
    //                                 <Button variant="outline" size="icon">
    //                                     <CircleUserRound className="h-[1.2rem] w-[1.2rem] rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0" />
    //                                     <span className="sr-only">Toggle theme</span>
    //                                 </Button>
    //                             </DropdownMenuTrigger>
    //                             <DropdownMenuContent align="end">
    //                                 <DropdownMenuItem >
    //                                     <Link href="/user/profile">{user['email']}</Link>
    //                                 </DropdownMenuItem>
    //                                 <DropdownMenuItem>
    //                                     <Logout />
    //                                 </DropdownMenuItem>
    //                             </DropdownMenuContent>
    //                         </DropdownMenu>
    //                     </li>
    //
    //                     <li><ModeToggle /></li>
    //
    //                 </ul>
    //             </nav>
    //         </div>
    // )

}