import { Inter } from "next/font/google";
import "./globals.css";
import {Toaster} from "sonner";


const inter = Inter({ subsets: ["latin"] });

export const metadata = {
  title: "NextJS App - Laravel JWT Authentication",
  description: "Generated by Fakhruddin Al-Mahmud",
};

export default function RootLayout({ children }) {

  return (
    <html lang="en">
      <body className={inter.className}>
            {children}
            <Toaster position="top-right" duration={3000}
                     toastOptions={{
                         classNames: {
                             toast: 'bg-green-600 text-white',
                             title: 'text-white font-bold',
                             description: 'text-lime-900',
                         }
                     }}/>
      </body>
    </html>
  );
}
