import axios from 'axios'


const api = axios.create({
    baseURL: 'https://api.portexbd.com/api', //'http://localhost:8000/api',
    withCredentials: true,
});

// export const registerUser = async (data) => {
//     const response = await api.post('/user-register', data)
//     return response.data
// }

export const registerUser = async (name, email, password, address, phone) => {
    const response = await api.post('/user-register', {name, email, password, address, phone})
    return response.data
}

export const loginUser = async (data) => {
    try{
        const response = await api.post('/user-login', data)
        return response.data
    }
    catch(err){
        return err.response
    }
}

export const logoutUser = async () => {
    const response = await api.get('/logout')
    // return response.data
}

export const sendOTP = async (email) => {
    const response = await api.post('/forgot-password', email)
    return response.data
}

export const verifyOTP = async (data) => {
    const response = await api.post('/verify-otp', data)
    return response.data
}

export const resetPassword = async (data) => {
    const response = await api.post('/reset-password', data)
    return response.data
}

export const fetchAdminInfo = async () => {
    const response = await api.get('/admin-data')
    return response.data
}

// export const fetchUserInfo = () => api.get('/user-data');

export const fetchUserInfo = async () => {
    const response = await api.get('/user-data')
    return response.data
}

export const fetchUserProfile = async () => {
    const response = await api.get('/user-profile')
    return response.data
}

// export const updateUserProfile = async (address, phone, image) => {
//     const response = await api.post('/update-user-profile', {address, phone, image})
//     return response.data
// }

export const updateUserProfile = async (updateData) => {
    const response = await api.post('/update-user-profile', updateData, {
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    });
    return response.data
}

export const changePassword = async (current_password, password) => {
    const response = await api.post('/change-password', {current_password, password})
    return response.data
}