import { ThemeProvider } from "@/components/theme-provider";
import Navbar from "../components/user/navbar";
import AdminNavbar from "@/app/components/admin/adminNavbar";
import AdminHeader from "@/app/components/admin/adminHeader";
export default function AdminLayout( {children} ) {
    return(
        <div>
            <ThemeProvider
                attribute="class"
                defaultTheme="system"
                enableSystem
                disableTransitionOnChange
            >
                {/*<Navbar />*/}
                {/*<main className="flex min-h-screen flex-col items-center p-24">*/}
                <div className="grid min-h-screen w-full md:grid-cols-[220px_1fr] lg:grid-cols-[240px_1fr]">
                    <AdminNavbar />
                    <div className="flex flex-col">
                        <AdminHeader />
                        <main className="flex flex-1 flex-col gap-4 p-4 lg:gap-6 lg:p-6">
                            {children}
                        </main>
                    </div>
                </div>
                {/*</main>*/}
            </ThemeProvider>
        </div>
    )
}