import { useState } from 'react';
import { useRouter } from 'next/navigation';
import {registerUser, loginUser, fetchUserInfo, logoutUser, fetchAdminInfo, fetchUserProfile} from './api';
import { jwtDecode } from 'jwt-decode';
import {toast} from "sonner";


const useAuth = () => {

    const [user, setUser] = useState(null);
    const router = useRouter();

    const register = async (name, email, password) => {
        const res = await registerUser({ name, email, password });
        setUser(res);
    }

    const login = async (email, password) => {
            try {
                const res = await loginUser({email, password});
                // console.log(res);

                if (res.status === "success") {
                    const decodeToken = jwtDecode(res['authToken']);
                    setUser(decodeToken);
                    // console.log('Decoded Token on Login:', decodeToken);

                    if (decodeToken['role'] === 'admin') {
                        router.push('/admin')
                    } else if (decodeToken['role'] === 'user') {
                        router.push('/user')
                    } else {
                        router.push('/')
                    }
                    toast.success(res.message);
                } else {
                    toast.error(res.data.message);
                }
            } catch (err) {
                console.error(err);
                toast.error('An unexpected error occurred. Please try again.');
            }
    }

    const logout = async () => {
        await logoutUser();
        setUser(null);
        router.push('/login');
    }

    const adminInfo = async () => {
        const adminInfo = await fetchAdminInfo();
        setUser(adminInfo);
        return adminInfo;
    }

    const userInfo = async () => {
        const userInfo = await fetchUserInfo();
        setUser(userInfo);
        return userInfo;
        // console.log(userInfo);
    }

    const userProfile = async () => {
        const userProfile = await fetchUserProfile();
        setUser(userProfile);
        return userProfile;
    }

    return {
        register,
        login,
        logout,
        adminInfo,
        userInfo,
        userProfile
    };
}

export default useAuth;