
import { NextResponse } from 'next/server';
import { jwtDecode } from "jwt-decode";
import {ADMIN, LOGIN, USER, PUBLIC_ROUTES} from "@/lib/routes";

export function middleware(request) {
    // === below are working well - to be fixed - Store for In-Future ===
    //======================================================================
    // const { nextUrl } = request;
    // const currentUserToken = request.cookies.get('authToken')?.value;
    //
    // if (!currentUserToken) {
    //     // No token, redirect to login
    //     if (nextUrl.pathname !== LOGIN) {
    //         return NextResponse.redirect(new URL(LOGIN, request.url));
    //     }
    //     return NextResponse.next();
    // }
    //
    // let decodedToken;
    // try {
    //     decodedToken = jwtDecode(currentUserToken);
    // } catch (error) {
    //     console.error('Failed to decode token', error);
    //     return NextResponse.redirect(new URL(LOGIN, request.url));
    // }
    //
    // const isAdminPage = nextUrl.pathname.startsWith(ADMIN);
    // const isUserPage = nextUrl.pathname === USER;
    // const isLoginPage = nextUrl.pathname === LOGIN;
    //
    // if (decodedToken.role === 'admin') {
    //     if (isUserPage) {
    //         return NextResponse.redirect(new URL(ADMIN, request.url));
    //     }
    //     if (isLoginPage) {
    //         return NextResponse.redirect(new URL(ADMIN, request.url));
    //     }
    // } else if (decodedToken.role === 'user') {
    //     if (isAdminPage) {
    //         return NextResponse.redirect(new URL(USER, request.url));
    //     }
    //     if (isLoginPage) {
    //         return NextResponse.redirect(new URL(USER, request.url));
    //     }
    // }
    //
    // // If the user is on the correct page for their role, allow the request to continue
    // return NextResponse.next();

    // === Currently using below ===
    const { nextUrl } = request;
    const currentUserToken = request.cookies.get('authToken')?.value;

    // Redirect PUBLIC_ROUTES
    if (!currentUserToken && PUBLIC_ROUTES.includes(nextUrl.pathname)) {
        return NextResponse.next();
    }

    // If there's no token, redirect to login
    if (!currentUserToken) {
        if (!PUBLIC_ROUTES.includes(nextUrl.pathname)) {
            return NextResponse.redirect(new URL(LOGIN, request.url));
        }
        return NextResponse.next();
    }

    let decodedToken;
    try {
        decodedToken = jwtDecode(currentUserToken);
        // If decodedToken expires more than 1 hour, redirect to login.
        if (decodedToken.exp && Date.now() >= decodedToken.exp * 1000) {
            const response = NextResponse.redirect(new URL(LOGIN, request.url));
            response.cookies.set('authToken', '', -1); // Remove the cookie - you can also use - response.cookies.set('authToken', '', { maxAge: 0 });
            return response;
        }
    } catch (error) {
        console.error('Failed to decode token', error);
        const response = NextResponse.redirect(new URL(LOGIN, request.url));
        response.cookies.set('authToken', '', -1); // Remove the cookie
        return response;
    }

    console.log(decodedToken);

    // Redirect logged-in users away from the login and public routes
    if (nextUrl.pathname === LOGIN || PUBLIC_ROUTES.includes(nextUrl.pathname)) {
        if (decodedToken.role === 'admin') {
            return NextResponse.redirect(new URL(ADMIN, request.url));
        } else if (decodedToken.role === 'user') {
            return NextResponse.redirect(new URL(USER, request.url));
        }
    }

    // Protect admin routes - Admin route is http://localhost:3000/admin
    if (nextUrl.pathname.startsWith(ADMIN) && decodedToken.role !== 'admin') {
        return NextResponse.redirect(new URL(USER, request.url));
    }

    // Protect user routes - User route is http://localhost:3000/user
    if (nextUrl.pathname.startsWith(USER) && decodedToken.role !== 'user') {
        return NextResponse.redirect(new URL(ADMIN, request.url));
    }

    return NextResponse.next();
}



// === below are working well - Without Role Based Routing ===
//======================================================================
// export function middleware(request) {
//     const { nextUrl } = request;
//     const currentUser = request.cookies.get('authToken')?.value;
//
//     const isAuthenticated = !!currentUser;
//     console.log(isAuthenticated, nextUrl.pathname);
//
//     if (isAuthenticated && nextUrl.pathname === LOGIN) {
//         return NextResponse.redirect(new URL( PRIVATE_ROUTES[0], request.url));
//     }
//
//     if (!isAuthenticated && nextUrl.pathname !== LOGIN) {
//         return NextResponse.redirect(new URL( LOGIN, request.url));
//     }
//
//     // const isPublicRoute = (PUBLIC_ROUTES.find(route => nextUrl.pathname.startsWith(route)) || nextUrl.pathname === LOGIN)
//     //     && !PRIVATE_ROUTES.find(route => nextUrl.pathname.startsWith(route));
//     // console.log(isPublicRoute);
//     //
//     // if (!isAuthenticated && !isPublicRoute) {
//     //     return NextResponse.redirect(new URL( LOGIN, request.url));
//     // }
//
//     //=== below are working well ===
//     // console.log(currentUser);
//     // // const decoded = jwtDecode(currentUser);
//     //
//     // if (!currentUser && nextUrl.pathname !== '/login') {
//     //     return NextResponse.redirect(new URL('/login', request.url));
//     // }
// }

export const config = {
    matcher: ["/((?!.+\\.[\\w]+$|_next).*)", "/", "/(api|trpc)(.*)"],
}